/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.config.GeneralConfig;
import com.tristankechlo.livingthings.config.entity.AncientBlazeConfig;
import com.tristankechlo.livingthings.config.entity.BabyEnderDragonConfig;
import com.tristankechlo.livingthings.config.entity.CrabConfig;
import com.tristankechlo.livingthings.config.entity.ElephantConfig;
import com.tristankechlo.livingthings.config.entity.FlamingoConfig;
import com.tristankechlo.livingthings.config.entity.GiraffeConfig;
import com.tristankechlo.livingthings.config.entity.KoalaConfig;
import com.tristankechlo.livingthings.config.entity.LionConfig;
import com.tristankechlo.livingthings.config.entity.MantarayConfig;
import com.tristankechlo.livingthings.config.entity.MonkeyConfig;
import com.tristankechlo.livingthings.config.entity.NetherKnightConfig;
import com.tristankechlo.livingthings.config.entity.OstrichConfig;
import com.tristankechlo.livingthings.config.entity.OwlConfig;
import com.tristankechlo.livingthings.config.entity.PeacockConfig;
import com.tristankechlo.livingthings.config.entity.PenguinConfig;
import com.tristankechlo.livingthings.config.entity.RaccoonConfig;
import com.tristankechlo.livingthings.config.entity.SeahorseConfig;
import com.tristankechlo.livingthings.config.entity.SharkConfig;
import com.tristankechlo.livingthings.config.entity.ShroomieConfig;
import com.tristankechlo.livingthings.config.entity.SnailConfig;
import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.platform.IPlatformHelper;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;

public final class ConfigManager {
    private static final List<EntityConfig> CONFIGS;
    public static final Gson GSON;
    private static final File CONFIG_DIR;

    public static void loadAndVerifyConfig() {
        ConfigManager.createConfigFolder();
        for (EntityConfig config : CONFIGS) {
            config.setToDefault();
            File configFile = new File(CONFIG_DIR, config.getFileName());
            if (configFile.exists()) {
                ConfigManager.loadConfigFromFile(configFile, config);
                ConfigManager.writeConfigToFile(configFile, config);
                LivingThings.LOGGER.info("Config '{}' was successfully loaded.", (Object)config.getFileName());
                continue;
            }
            ConfigManager.writeConfigToFile(configFile, config);
            LivingThings.LOGGER.warn("No config '{}' was found, created a new one.", (Object)config.getFileName());
        }
    }

    private static void writeConfigToFile(File file, EntityConfig config) {
        try {
            JsonElement json = config.serialize(new JsonObject());
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("\t");
            GSON.toJson(json, writer);
            writer.close();
        }
        catch (Exception e) {
            LivingThings.LOGGER.error("There was an error writing the config to file: '{}'", (Object)config.getFileName());
            e.printStackTrace();
        }
    }

    private static void loadConfigFromFile(File file, EntityConfig config) {
        JsonObject json = null;
        try {
            JsonParser parser = new JsonParser();
            JsonElement jsonElement = parser.parse((Reader)new FileReader(file));
            json = jsonElement.getAsJsonObject();
        }
        catch (JsonSyntaxException e) {
            LivingThings.LOGGER.error("The config file '{}' is not valid json.", (Object)config.getFileName());
            e.printStackTrace();
        }
        catch (Exception e) {
            LivingThings.LOGGER.error("There was an error loading the config file: '{}'", (Object)config.getFileName());
            e.printStackTrace();
        }
        if (json != null) {
            config.deserialize(json);
            return;
        }
        LivingThings.LOGGER.error("Error loading config '{}', config hasn't been loaded.", (Object)config.getFileName());
    }

    private static void createConfigFolder() {
        if (!CONFIG_DIR.exists() && !CONFIG_DIR.mkdirs()) {
            throw new RuntimeException("Could not create config folder: " + CONFIG_DIR.getAbsolutePath());
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
        CONFIG_DIR = IPlatformHelper.INSTANCE.getConfigDirectory().resolve("livingthings").toFile();
        CONFIGS = List.of(GeneralConfig.get(), PenguinConfig.get(), ElephantConfig.get(), GiraffeConfig.get(), LionConfig.get(), SharkConfig.get(), OstrichConfig.get(), FlamingoConfig.get(), CrabConfig.get(), MantarayConfig.get(), RaccoonConfig.get(), OwlConfig.get(), AncientBlazeConfig.get(), KoalaConfig.get(), SnailConfig.get(), MonkeyConfig.get(), NetherKnightConfig.get(), ShroomieConfig.get(), SeahorseConfig.get(), BabyEnderDragonConfig.get(), PeacockConfig.get());
    }
}

